local t = Def.ActorFrame {}
local MemCardStates = {
	MemoryCardState_ready = 0;
	MemoryCardState_checking = 1;
	MemoryCardState_late = 2;
	MemoryCardState_error = 3;
	MemoryCardState_removed = 4;
	MemoryCardState_none = 5;
}

--sysmessages
t[#t+1] = LoadFont("ArialOutline")..{
	InitCommand=cmd(x,10;y,5;wrapwidthpixels,SCREEN_WIDTH*1.8;horizalign,left;vertalign,top;zoom,0.6;shadowlength,0);
	SystemMessageMessageCommand=function(self,params)
		self:settext(params.Message);
		self:finishtweening();
		self:diffusealpha(1);
		self:sleep(3);
		self:diffusealpha(0);
	end;
	HideSystemMessageMessageCommand=cmd(finishtweening);
};

--CREDIT(S) 1 [0/3]
t[#t+1] = LoadFont("credits")..{
	InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_BOTTOM-12;zoom,1;shadowlength,0;playcommand,"Text");
	TextCommand=function(self)
		self:visible(false);
		if GAMESTATE:GetCoinMode() == 'CoinMode_Pay' then
			self:visible(true);
			local Coins = GAMESTATE:GetCoins()
			local CoinForCredit = GAMESTATE:GetCoinsNeededToJoin()
			local Credits = math.floor(Coins/CoinForCredit)
			local Remain = Coins % CoinForCredit
			self:settext(string.format("CRDTS%i(%i/%i)", Credits, Remain, CoinForCredit))
		end
	end;
	PlayerJoinedMessageCommand=cmd(playcommand,"Text");
	CoinInsertedMessageCommand=cmd(playcommand,"Text");
	CoinModeChangedMessageCommand=cmd(playcommand,"Text");
	ScreenChangedMessageCommand=cmd(playcommand,"Text");
}

for player in ivalues(PlayerNumber) do
--nombre del perfil de los jugadores
t[#t+1] = LoadFont("ArialOutline")..{
	InitCommand=function(self)
		(cmd(y,SCREEN_BOTTOM-12;shadowlength,0;zoom,0.75))(self);
		self:x(player == PLAYER_1 and 8 or SCREEN_WIDTH-8);
		self:horizalign(player == PLAYER_1 and left or right);
	end;
	TextCommand=function(self)
		self:settext("");
		if PROFILEMAN:IsPersistentProfile(player) then
			local Profile = PROFILEMAN:GetProfile(player)
			local IdName = Profile:GetDisplayName()
			--local Jokes = string.lower(IdName)
			if IdName == "" then
				--IdName = "Name Me"
				IdName = string.gsub(player,"Number_P"," ")
			end
			--[[K//tern!
			--if string.find(Jokes,"k") and string.find(Jokes,"tern") then
				local Attr = {
					Length = 2;
					Diffuse = color("#FF0000");
				};
				self:AddAttribute(1,Attr);
			--kaox!
			elseif string.find(Jokes,"kaox") then
				self:diffuse(color("#00FF00"));
				IdName = "Mono"
			--Daisu master!
			elseif string.find(Jokes,"*daisu") then
				self:diffuse(color("#0055FF"));
			--Lnkn!
			elseif string.find(Jokes,"lnkn") or string.find(Jokes,"linkin") or string.find(Jokes,"jpms") then
				self:diffuse(color("#FF0000"));
			--AJ!
			elseif string.find(Jokes,"aj") and string.find(Jokes,"187") then
				self:diffuse(color("#00C0FF"));
			end]]
			self:settext(IdName);
		end;
	end;
	PlayerJoinedMessageCommand=cmd(playcommand,"Text");
	CoinInsertedMessageCommand=cmd(playcommand,"Text");
	CoinModeChangedMessageCommand=cmd(playcommand,"Text");
	ScreenChangedMessageCommand=cmd(playcommand,"Text");
	StorageDevicesChangedMessageCommand=cmd(playcommand,"Text");
}

--iconos del estado de la memoria USB
t[#t+1] = LoadActor("MemoryCardStates")..{
	InitCommand=function(self)
		(cmd(y,SCREEN_BOTTOM-30;pause))(self);
		self:x(player == PLAYER_1 and 20 or SCREEN_WIDTH-20);
	end;
	UpdateCommand=function(self)
		local sMcState = MEMCARDMAN:GetCardState(player)
		self:setstate(MemCardStates[sMcState])
	end;
	ScreenChangedMessageCommand=cmd(playcommand,"Update");
	StorageDevicesChangedMessageCommand=cmd(playcommand,"Update");
}

end

--sonidos de las fichas
t[#t+1] = Def.Actor {
	CoinInsertedMessageCommand=function(self)
		local coins = GAMESTATE:GetCoins()
		local cointojoin = GAMESTATE:GetCoinsNeededToJoin()
		local remain = coins % cointojoin
		if remain == 0 then
			SOUND:PlayOnce(THEME:GetPathS("","COIN2"));
		else
			SOUND:PlayOnce(THEME:GetPathS("","COIN1"));
		end
	end;
}

t.ScreenChangedMessageCommand=function(self)
	self:visible(THEME:GetMetric(SCREENMAN:GetTopScreen():GetName(),"ShowCoinsAndCredits"));
end

return t